<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Index du répertoire</title>
    <style>
        body { 
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; 
            margin: 40px auto; 
            max-width: 800px; 
            padding: 0 20px;
            color: #333;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin-top: 20px;
        }
        th, td { 
            padding: 12px 15px; 
            text-align: left; 
            border-bottom: 1px solid #ddd; 
        }
        th { 
            background-color: #f4f4f4; 
        }
        tr:hover { 
            background-color: #f1f1f1; 
        }
        a { 
            text-decoration: none; 
            color: #007bff;
        }
        a:hover { 
            text-decoration: underline; 
        }
        .icon {
            margin-right: 10px;
        }
    </style>
</head>
<body>

    <h1>Index de : <?php echo htmlspecialchars(basename(__DIR__)); ?></h1>

    <table>
        <thead>
            <tr>
                <th>Nom</th>
                <th>Taille</th>
                <th>Dernière modification</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Récupère le chemin du répertoire courant
            $currentDir = '.';

            // Ouvre le répertoire et lit son contenu
            $items = scandir($currentDir);

            // Gère le lien pour remonter au répertoire parent (sauf si on est à la racine)
            if (realpath($currentDir) !== realpath($_SERVER['DOCUMENT_ROOT'])) {
                echo '<tr>';
                echo '<td><a href=".."><span class="icon">📁</span>.. (Parent)</a></td>';
                echo '<td>-</td>';
                echo '<td>-</td>';
                echo '</tr>';
            }
            
            // Boucle sur chaque élément du répertoire
            foreach ($items as $item) {
                // Exclut le répertoire courant ('.') et le script lui-même
                if ($item == '.' || $item == basename(__FILE__)) {
                    continue;
                }
                // Le lien vers le répertoire parent ('..') est déjà géré
                if ($item == '..') {
                    continue;
                }

                $path = $currentDir . '/' . $item;
                $isDir = is_dir($path);
                
                echo '<tr>';
                
                // Colonne Nom (avec icône et lien)
                $icon = $isDir ? '📁' : '📄';
                echo '<td><a href="' . htmlspecialchars(rawurlencode($item)) . '"><span class="icon">' . $icon . '</span>' . htmlspecialchars($item) . '</a></td>';
                
                // Colonne Taille
                if ($isDir) {
                    echo '<td>-</td>';
                } else {
                    $size = filesize($path);
                    // Formate la taille pour être plus lisible
                    $units = ['o', 'Ko', 'Mo', 'Go', 'To'];
                    $i = 0;
                    while ($size >= 1024 && $i < count($units) - 1) {
                        $size /= 1024;
                        $i++;
                    }
                    echo '<td>' . round($size, 1) . ' ' . $units[$i] . '</td>';
                }

                // Colonne Date de modification
                echo '<td>' . date("d/m/Y H:i", filemtime($path)) . '</td>';
                
                echo '</tr>';
            }
            ?>
        </tbody>
    </table>

</body>
</html>